package dcm.org.dcm4che3.data;

import java.util.ResourceBundle;

public class UID {
	private static final ResourceBundle rb = ResourceBundle
			.getBundle("dcm.org.dcm4che3.data.UIDNames");
	public static final String VerificationSOPClass = "1.2.840.10008.1.1";
	public static final String ImplicitVRLittleEndian = "1.2.840.10008.1.2";
	public static final String ExplicitVRLittleEndian = "1.2.840.10008.1.2.1";

	public static String nameOf(String uid) {
		try {
			return rb.getString(uid);
		} catch (Exception e) {
		}
		return "?";
	}

	public static final String DeflatedExplicitVRLittleEndian = "1.2.840.10008.1.2.1.99";
	public static final String ExplicitVRBigEndianRetired = "1.2.840.10008.1.2.2";
	public static final String JPEGBaseline1 = "1.2.840.10008.1.2.4.50";

	public static String forName(String keyword) {
		try {
			return (String) UID.class.getField(keyword).get(null);
		} catch (Exception e) {
			/* 65 */throw new IllegalArgumentException(keyword);
		}
	}

	public static final String JPEGExtended24 = "1.2.840.10008.1.2.4.51";
	public static final String JPEGExtended35Retired = "1.2.840.10008.1.2.4.52";
	public static final String JPEGSpectralSelectionNonHierarchical68Retired = "1.2.840.10008.1.2.4.53";
	public static final String JPEGSpectralSelectionNonHierarchical79Retired = "1.2.840.10008.1.2.4.54";
	public static final String JPEGFullProgressionNonHierarchical1012Retired = "1.2.840.10008.1.2.4.55";
	public static final String JPEGFullProgressionNonHierarchical1113Retired = "1.2.840.10008.1.2.4.56";
	public static final String JPEGLosslessNonHierarchical14 = "1.2.840.10008.1.2.4.57";
	public static final String JPEGLosslessNonHierarchical15Retired = "1.2.840.10008.1.2.4.58";
	public static final String JPEGExtendedHierarchical1618Retired = "1.2.840.10008.1.2.4.59";
	public static final String JPEGExtendedHierarchical1719Retired = "1.2.840.10008.1.2.4.60";
	public static final String JPEGSpectralSelectionHierarchical2022Retired = "1.2.840.10008.1.2.4.61";
	public static final String JPEGSpectralSelectionHierarchical2123Retired = "1.2.840.10008.1.2.4.62";
	public static final String JPEGFullProgressionHierarchical2426Retired = "1.2.840.10008.1.2.4.63";
	public static final String JPEGFullProgressionHierarchical2527Retired = "1.2.840.10008.1.2.4.64";
	public static final String JPEGLosslessHierarchical28Retired = "1.2.840.10008.1.2.4.65";
	public static final String JPEGLosslessHierarchical29Retired = "1.2.840.10008.1.2.4.66";
	public static final String JPEGLossless = "1.2.840.10008.1.2.4.70";
	public static final String JPEGLSLossless = "1.2.840.10008.1.2.4.80";
	public static final String JPEGLSLossyNearLossless = "1.2.840.10008.1.2.4.81";
	public static final String JPEG2000LosslessOnly = "1.2.840.10008.1.2.4.90";
	public static final String JPEG2000 = "1.2.840.10008.1.2.4.91";
	public static final String JPEG2000Part2MultiComponentLosslessOnly = "1.2.840.10008.1.2.4.92";
	public static final String JPEG2000Part2MultiComponent = "1.2.840.10008.1.2.4.93";
	public static final String JPIPReferenced = "1.2.840.10008.1.2.4.94";
	public static final String JPIPReferencedDeflate = "1.2.840.10008.1.2.4.95";
	public static final String MPEG2 = "1.2.840.10008.1.2.4.100";
	public static final String MPEG2MainProfileHighLevel = "1.2.840.10008.1.2.4.101";
	public static final String MPEG4AVCH264HighProfileLevel41 = "1.2.840.10008.1.2.4.102";
	public static final String MPEG4AVCH264BDCompatibleHighProfileLevel41 = "1.2.840.10008.1.2.4.103";
	public static final String MPEG4AVCH264HighProfileLevel42For2DVideo = "1.2.840.10008.1.2.4.104";
	public static final String MPEG4AVCH264HighProfileLevel42For3DVideo = "1.2.840.10008.1.2.4.105";
	public static final String MPEG4AVCH264StereoHighProfileLevel42 = "1.2.840.10008.1.2.4.106";
	public static final String HEVCH265MainProfileLevel51 = "1.2.840.10008.1.2.4.107";
	public static final String HEVCH265Main10ProfileLevel51 = "1.2.840.10008.1.2.4.108";
	public static final String RLELossless = "1.2.840.10008.1.2.5";
	public static final String RFC2557MIMEEncapsulation = "1.2.840.10008.1.2.6.1";
	public static final String XMLEncoding = "1.2.840.10008.1.2.6.2";
	public static final String MediaStorageDirectoryStorage = "1.2.840.10008.1.3.10";
	public static final String TalairachBrainAtlasFrameOfReference = "1.2.840.10008.1.4.1.1";
	public static final String SPM2T1FrameOfReference = "1.2.840.10008.1.4.1.2";
	public static final String SPM2T2FrameOfReference = "1.2.840.10008.1.4.1.3";
	public static final String SPM2PDFrameOfReference = "1.2.840.10008.1.4.1.4";
	public static final String SPM2EPIFrameOfReference = "1.2.840.10008.1.4.1.5";
	public static final String SPM2FILT1FrameOfReference = "1.2.840.10008.1.4.1.6";
	public static final String SPM2PETFrameOfReference = "1.2.840.10008.1.4.1.7";
	public static final String SPM2TRANSMFrameOfReference = "1.2.840.10008.1.4.1.8";
	public static final String SPM2SPECTFrameOfReference = "1.2.840.10008.1.4.1.9";
	public static final String SPM2GRAYFrameOfReference = "1.2.840.10008.1.4.1.10";
	public static final String SPM2WHITEFrameOfReference = "1.2.840.10008.1.4.1.11";
	public static final String SPM2CSFFrameOfReference = "1.2.840.10008.1.4.1.12";
	public static final String SPM2BRAINMASKFrameOfReference = "1.2.840.10008.1.4.1.13";
	public static final String SPM2AVG305T1FrameOfReference = "1.2.840.10008.1.4.1.14";
	public static final String SPM2AVG152T1FrameOfReference = "1.2.840.10008.1.4.1.15";
	public static final String SPM2AVG152T2FrameOfReference = "1.2.840.10008.1.4.1.16";
	public static final String SPM2AVG152PDFrameOfReference = "1.2.840.10008.1.4.1.17";
	public static final String SPM2SINGLESUBJT1FrameOfReference = "1.2.840.10008.1.4.1.18";
	public static final String ICBM452T1FrameOfReference = "1.2.840.10008.1.4.2.1";
	public static final String ICBMSingleSubjectMRIFrameOfReference = "1.2.840.10008.1.4.2.2";
	public static final String HotIronColorPaletteSOPInstance = "1.2.840.10008.1.5.1";
	public static final String PETColorPaletteSOPInstance = "1.2.840.10008.1.5.2";
	public static final String HotMetalBlueColorPaletteSOPInstance = "1.2.840.10008.1.5.3";
	public static final String PET20StepColorPaletteSOPInstance = "1.2.840.10008.1.5.4";
	public static final String SpringColorPaletteSOPInstance = "1.2.840.10008.1.5.5";
	public static final String SummerColorPaletteSOPInstance = "1.2.840.10008.1.5.6";
	public static final String FallColorPaletteSOPInstance = "1.2.840.10008.1.5.7";
	public static final String WinterColorPaletteSOPInstance = "1.2.840.10008.1.5.8";
	public static final String BasicStudyContentNotificationSOPClassRetired = "1.2.840.10008.1.9";
	public static final String Papyrus3ImplicitVRLittleEndianRetired = "1.2.840.10008.1.20";
	public static final String StorageCommitmentPushModelSOPClass = "1.2.840.10008.1.20.1";
	public static final String StorageCommitmentPushModelSOPInstance = "1.2.840.10008.1.20.1.1";
	public static final String StorageCommitmentPullModelSOPClassRetired = "1.2.840.10008.1.20.2";
	public static final String StorageCommitmentPullModelSOPInstanceRetired = "1.2.840.10008.1.20.2.1";
	public static final String ProceduralEventLoggingSOPClass = "1.2.840.10008.1.40";
	public static final String ProceduralEventLoggingSOPInstance = "1.2.840.10008.1.40.1";
	public static final String SubstanceAdministrationLoggingSOPClass = "1.2.840.10008.1.42";
	public static final String SubstanceAdministrationLoggingSOPInstance = "1.2.840.10008.1.42.1";
	public static final String DICOMUIDRegistry = "1.2.840.10008.2.6.1";
	public static final String DICOMControlledTerminology = "1.2.840.10008.2.16.4";
	public static final String AdultMouseAnatomyOntology = "1.2.840.10008.2.16.5";
	public static final String UberonOntology = "1.2.840.10008.2.16.6";
	public static final String IntegratedTaxonomicInformationSystemITISTaxonomicSerialNumberTSN = "1.2.840.10008.2.16.7";
	public static final String MouseGenomeInitiativeMGI = "1.2.840.10008.2.16.8";
	public static final String PubChemCompoundCID = "1.2.840.10008.2.16.9";
	public static final String DICOMApplicationContextName = "1.2.840.10008.3.1.1.1";
	public static final String DetachedPatientManagementSOPClassRetired = "1.2.840.10008.3.1.2.1.1";
	public static final String DetachedPatientManagementMetaSOPClassRetired = "1.2.840.10008.3.1.2.1.4";
	public static final String DetachedVisitManagementSOPClassRetired = "1.2.840.10008.3.1.2.2.1";
	public static final String DetachedStudyManagementSOPClassRetired = "1.2.840.10008.3.1.2.3.1";
	public static final String StudyComponentManagementSOPClassRetired = "1.2.840.10008.3.1.2.3.2";
	public static final String ModalityPerformedProcedureStepSOPClass = "1.2.840.10008.3.1.2.3.3";
	public static final String ModalityPerformedProcedureStepRetrieveSOPClass = "1.2.840.10008.3.1.2.3.4";
	public static final String ModalityPerformedProcedureStepNotificationSOPClass = "1.2.840.10008.3.1.2.3.5";
	public static final String DetachedResultsManagementSOPClassRetired = "1.2.840.10008.3.1.2.5.1";
	public static final String DetachedResultsManagementMetaSOPClassRetired = "1.2.840.10008.3.1.2.5.4";
	public static final String DetachedStudyManagementMetaSOPClassRetired = "1.2.840.10008.3.1.2.5.5";
	public static final String DetachedInterpretationManagementSOPClassRetired = "1.2.840.10008.3.1.2.6.1";
	public static final String StorageServiceClass = "1.2.840.10008.4.2";
	public static final String BasicFilmSessionSOPClass = "1.2.840.10008.5.1.1.1";
	public static final String BasicFilmBoxSOPClass = "1.2.840.10008.5.1.1.2";
	public static final String BasicGrayscaleImageBoxSOPClass = "1.2.840.10008.5.1.1.4";
	public static final String BasicColorImageBoxSOPClass = "1.2.840.10008.5.1.1.4.1";
	public static final String ReferencedImageBoxSOPClassRetired = "1.2.840.10008.5.1.1.4.2";
	public static final String BasicGrayscalePrintManagementMetaSOPClass = "1.2.840.10008.5.1.1.9";
	public static final String ReferencedGrayscalePrintManagementMetaSOPClassRetired = "1.2.840.10008.5.1.1.9.1";
	public static final String PrintJobSOPClass = "1.2.840.10008.5.1.1.14";
	public static final String BasicAnnotationBoxSOPClass = "1.2.840.10008.5.1.1.15";
	public static final String PrinterSOPClass = "1.2.840.10008.5.1.1.16";
	public static final String PrinterConfigurationRetrievalSOPClass = "1.2.840.10008.5.1.1.16.376";
	public static final String PrinterSOPInstance = "1.2.840.10008.5.1.1.17";
	public static final String PrinterConfigurationRetrievalSOPInstance = "1.2.840.10008.5.1.1.17.376";
	public static final String BasicColorPrintManagementMetaSOPClass = "1.2.840.10008.5.1.1.18";
	public static final String ReferencedColorPrintManagementMetaSOPClassRetired = "1.2.840.10008.5.1.1.18.1";
	public static final String VOILUTBoxSOPClass = "1.2.840.10008.5.1.1.22";
	public static final String PresentationLUTSOPClass = "1.2.840.10008.5.1.1.23";
	public static final String ImageOverlayBoxSOPClassRetired = "1.2.840.10008.5.1.1.24";
	public static final String BasicPrintImageOverlayBoxSOPClassRetired = "1.2.840.10008.5.1.1.24.1";
	public static final String PrintQueueSOPInstanceRetired = "1.2.840.10008.5.1.1.25";
	public static final String PrintQueueManagementSOPClassRetired = "1.2.840.10008.5.1.1.26";
	public static final String StoredPrintStorageSOPClassRetired = "1.2.840.10008.5.1.1.27";
	public static final String HardcopyGrayscaleImageStorageSOPClassRetired = "1.2.840.10008.5.1.1.29";
	public static final String HardcopyColorImageStorageSOPClassRetired = "1.2.840.10008.5.1.1.30";
	public static final String PullPrintRequestSOPClassRetired = "1.2.840.10008.5.1.1.31";
	public static final String PullStoredPrintManagementMetaSOPClassRetired = "1.2.840.10008.5.1.1.32";
	public static final String MediaCreationManagementSOPClassUID = "1.2.840.10008.5.1.1.33";
	public static final String DisplaySystemSOPClass = "1.2.840.10008.5.1.1.40";
	public static final String DisplaySystemSOPInstance = "1.2.840.10008.5.1.1.40.1";
	public static final String ComputedRadiographyImageStorage = "1.2.840.10008.5.1.4.1.1.1";
	public static final String DigitalXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.1";
	public static final String DigitalXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.1.1";
	public static final String DigitalMammographyXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.2";
	public static final String DigitalMammographyXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.2.1";
	public static final String DigitalIntraOralXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.3";
	public static final String DigitalIntraOralXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.3.1";
	public static final String CTImageStorage = "1.2.840.10008.5.1.4.1.1.2";
	public static final String EnhancedCTImageStorage = "1.2.840.10008.5.1.4.1.1.2.1";
	public static final String LegacyConvertedEnhancedCTImageStorage = "1.2.840.10008.5.1.4.1.1.2.2";
	public static final String UltrasoundMultiFrameImageStorageRetired = "1.2.840.10008.5.1.4.1.1.3";
	public static final String UltrasoundMultiFrameImageStorage = "1.2.840.10008.5.1.4.1.1.3.1";
	public static final String MRImageStorage = "1.2.840.10008.5.1.4.1.1.4";
	public static final String EnhancedMRImageStorage = "1.2.840.10008.5.1.4.1.1.4.1";
	public static final String MRSpectroscopyStorage = "1.2.840.10008.5.1.4.1.1.4.2";
	public static final String EnhancedMRColorImageStorage = "1.2.840.10008.5.1.4.1.1.4.3";
	public static final String LegacyConvertedEnhancedMRImageStorage = "1.2.840.10008.5.1.4.1.1.4.4";
	public static final String NuclearMedicineImageStorageRetired = "1.2.840.10008.5.1.4.1.1.5";
	public static final String UltrasoundImageStorageRetired = "1.2.840.10008.5.1.4.1.1.6";
	public static final String UltrasoundImageStorage = "1.2.840.10008.5.1.4.1.1.6.1";
	public static final String EnhancedUSVolumeStorage = "1.2.840.10008.5.1.4.1.1.6.2";
	public static final String SecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7";
	public static final String MultiFrameSingleBitSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.1";
	public static final String MultiFrameGrayscaleByteSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.2";
	public static final String MultiFrameGrayscaleWordSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.3";
	public static final String MultiFrameTrueColorSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.4";
	public static final String StandaloneOverlayStorageRetired = "1.2.840.10008.5.1.4.1.1.8";
	public static final String StandaloneCurveStorageRetired = "1.2.840.10008.5.1.4.1.1.9";
	public static final String WaveformStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.9.1";
	public static final String TwelveLeadECGWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.1.1";
	public static final String GeneralECGWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.1.2";
	public static final String AmbulatoryECGWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.1.3";
	public static final String HemodynamicWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.2.1";
	public static final String CardiacElectrophysiologyWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.3.1";
	public static final String BasicVoiceAudioWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.4.1";
	public static final String GeneralAudioWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.4.2";
	public static final String ArterialPulseWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.5.1";
	public static final String RespiratoryWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.6.1";
	public static final String StandaloneModalityLUTStorageRetired = "1.2.840.10008.5.1.4.1.1.10";
	public static final String StandaloneVOILUTStorageRetired = "1.2.840.10008.5.1.4.1.1.11";
	public static final String GrayscaleSoftcopyPresentationStateStorageSOPClass = "1.2.840.10008.5.1.4.1.1.11.1";
	public static final String ColorSoftcopyPresentationStateStorageSOPClass = "1.2.840.10008.5.1.4.1.1.11.2";
	public static final String PseudoColorSoftcopyPresentationStateStorageSOPClass = "1.2.840.10008.5.1.4.1.1.11.3";
	public static final String BlendingSoftcopyPresentationStateStorageSOPClass = "1.2.840.10008.5.1.4.1.1.11.4";
	public static final String XAXRFGrayscaleSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.5";
	public static final String GrayscalePlanarMPRVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.6";
	public static final String CompositingPlanarMPRVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.7";
	public static final String XRayAngiographicImageStorage = "1.2.840.10008.5.1.4.1.1.12.1";
	public static final String EnhancedXAImageStorage = "1.2.840.10008.5.1.4.1.1.12.1.1";
	public static final String XRayRadiofluoroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.12.2";
	public static final String EnhancedXRFImageStorage = "1.2.840.10008.5.1.4.1.1.12.2.1";
	public static final String XRayAngiographicBiPlaneImageStorageRetired = "1.2.840.10008.5.1.4.1.1.12.3";
	public static final String ZeissOPTFileRetired = "1.2.840.10008.5.1.4.1.1.12.77";
	public static final String XRay3DAngiographicImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.1";
	public static final String XRay3DCraniofacialImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.2";
	public static final String BreastTomosynthesisImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.3";
	public static final String BreastProjectionXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.13.1.4";
	public static final String BreastProjectionXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.13.1.5";
	public static final String IntravascularOpticalCoherenceTomographyImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.14.1";
	public static final String IntravascularOpticalCoherenceTomographyImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.14.2";
	public static final String NuclearMedicineImageStorage = "1.2.840.10008.5.1.4.1.1.20";
	public static final String ParametricMapStorage = "1.2.840.10008.5.1.4.1.1.30";
	public static final String MRImageStorageZeroPaddedRetired = "1.2.840.10008.5.1.4.1.1.40";
	public static final String RawDataStorage = "1.2.840.10008.5.1.4.1.1.66";
	public static final String SpatialRegistrationStorage = "1.2.840.10008.5.1.4.1.1.66.1";
	public static final String SpatialFiducialsStorage = "1.2.840.10008.5.1.4.1.1.66.2";
	public static final String DeformableSpatialRegistrationStorage = "1.2.840.10008.5.1.4.1.1.66.3";
	public static final String SegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.4";
	public static final String SurfaceSegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.5";
	public static final String TractographyResultsStorage = "1.2.840.10008.5.1.4.1.1.66.6";
	public static final String RealWorldValueMappingStorage = "1.2.840.10008.5.1.4.1.1.67";
	public static final String SurfaceScanMeshStorage = "1.2.840.10008.5.1.4.1.1.68.1";
	public static final String SurfaceScanPointCloudStorage = "1.2.840.10008.5.1.4.1.1.68.2";
	public static final String VLImageStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.77.1";
	public static final String VLMultiFrameImageStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.77.2";
	public static final String VLEndoscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.1";
	public static final String VideoEndoscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.1.1";
	public static final String VLMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.2";
	public static final String VideoMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.2.1";
	public static final String VLSlideCoordinatesMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.3";
	public static final String VLPhotographicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.4";
	public static final String VideoPhotographicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.4.1";
	public static final String OphthalmicPhotography8BitImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.1";
	public static final String OphthalmicPhotography16BitImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.2";
	public static final String StereometricRelationshipStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.3";
	public static final String OphthalmicTomographyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.4";
	public static final String WideFieldOphthalmicPhotographyStereographicProjectionImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.5";
	public static final String WideFieldOphthalmicPhotography3DCoordinatesImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.6";
	public static final String VLWholeSlideMicroscopyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.6";
	public static final String LensometryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.1";
	public static final String AutorefractionMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.2";
	public static final String KeratometryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.3";
	public static final String SubjectiveRefractionMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.4";
	public static final String VisualAcuityMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.5";
	public static final String SpectaclePrescriptionReportStorage = "1.2.840.10008.5.1.4.1.1.78.6";
	public static final String OphthalmicAxialMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.7";
	public static final String IntraocularLensCalculationsStorage = "1.2.840.10008.5.1.4.1.1.78.8";
	public static final String MacularGridThicknessAndVolumeReportStorage = "1.2.840.10008.5.1.4.1.1.79.1";
	public static final String OphthalmicVisualFieldStaticPerimetryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.80.1";
	public static final String OphthalmicThicknessMapStorage = "1.2.840.10008.5.1.4.1.1.81.1";
	public static final String CornealTopographyMapStorage = "1.2.840.10008.5.1.4.1.1.82.1";
	public static final String TextSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.1";
	public static final String AudioSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.2";
	public static final String DetailSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.3";
	public static final String ComprehensiveSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.4";
	public static final String BasicTextSRStorage = "1.2.840.10008.5.1.4.1.1.88.11";
	public static final String EnhancedSRStorage = "1.2.840.10008.5.1.4.1.1.88.22";
	public static final String ComprehensiveSRStorage = "1.2.840.10008.5.1.4.1.1.88.33";
	public static final String Comprehensive3DSRStorage = "1.2.840.10008.5.1.4.1.1.88.34";
	public static final String ExtensibleSRStorage = "1.2.840.10008.5.1.4.1.1.88.35";
	public static final String ProcedureLogStorage = "1.2.840.10008.5.1.4.1.1.88.40";
	public static final String MammographyCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.50";
	public static final String KeyObjectSelectionDocumentStorage = "1.2.840.10008.5.1.4.1.1.88.59";
	public static final String ChestCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.65";
	public static final String XRayRadiationDoseSRStorage = "1.2.840.10008.5.1.4.1.1.88.67";
	public static final String RadiopharmaceuticalRadiationDoseSRStorage = "1.2.840.10008.5.1.4.1.1.88.68";
	public static final String ColonCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.69";
	public static final String ImplantationPlanSRStorage = "1.2.840.10008.5.1.4.1.1.88.70";
	public static final String AcquisitionContextSRStorage = "1.2.840.10008.5.1.4.1.1.88.71";
	public static final String SimplifiedAdultEchoSRStorage = "1.2.840.10008.5.1.4.1.1.88.72";
	public static final String ContentAssessmentResultsStorage = "1.2.840.10008.5.1.4.1.1.90.1";
	public static final String EncapsulatedPDFStorage = "1.2.840.10008.5.1.4.1.1.104.1";
	public static final String EncapsulatedCDAStorage = "1.2.840.10008.5.1.4.1.1.104.2";
	public static final String PositronEmissionTomographyImageStorage = "1.2.840.10008.5.1.4.1.1.128";
	public static final String LegacyConvertedEnhancedPETImageStorage = "1.2.840.10008.5.1.4.1.1.128.1";
	public static final String StandalonePETCurveStorageRetired = "1.2.840.10008.5.1.4.1.1.129";
	public static final String EnhancedPETImageStorage = "1.2.840.10008.5.1.4.1.1.130";
	public static final String BasicStructuredDisplayStorage = "1.2.840.10008.5.1.4.1.1.131";
	public static final String CTDefinedProcedureProtocolStorage = "1.2.840.10008.5.1.4.1.1.200.1";
	public static final String CTPerformedProcedureProtocolStorage = "1.2.840.10008.5.1.4.1.1.200.2";
	public static final String RTImageStorage = "1.2.840.10008.5.1.4.1.1.481.1";
	public static final String RTDoseStorage = "1.2.840.10008.5.1.4.1.1.481.2";
	public static final String RTStructureSetStorage = "1.2.840.10008.5.1.4.1.1.481.3";
	public static final String RTBeamsTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.4";
	public static final String RTPlanStorage = "1.2.840.10008.5.1.4.1.1.481.5";
	public static final String RTBrachyTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.6";
	public static final String RTTreatmentSummaryRecordStorage = "1.2.840.10008.5.1.4.1.1.481.7";
	public static final String RTIonPlanStorage = "1.2.840.10008.5.1.4.1.1.481.8";
	public static final String RTIonBeamsTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.9";
	public static final String DICOSCTImageStorage = "1.2.840.10008.5.1.4.1.1.501.1";
	public static final String DICOSDigitalXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.501.2.1";
	public static final String DICOSDigitalXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.501.2.2";
	public static final String DICOSThreatDetectionReportStorage = "1.2.840.10008.5.1.4.1.1.501.3";
	public static final String DICOS2DAITStorage = "1.2.840.10008.5.1.4.1.1.501.4";
	public static final String DICOS3DAITStorage = "1.2.840.10008.5.1.4.1.1.501.5";
	public static final String DICOSQuadrupoleResonanceQRStorage = "1.2.840.10008.5.1.4.1.1.501.6";
	public static final String EddyCurrentImageStorage = "1.2.840.10008.5.1.4.1.1.601.1";
	public static final String EddyCurrentMultiFrameImageStorage = "1.2.840.10008.5.1.4.1.1.601.2";
	public static final String PatientRootQueryRetrieveInformationModelFIND = "1.2.840.10008.5.1.4.1.2.1.1";
	public static final String PatientRootQueryRetrieveInformationModelMOVE = "1.2.840.10008.5.1.4.1.2.1.2";
	public static final String PatientRootQueryRetrieveInformationModelGET = "1.2.840.10008.5.1.4.1.2.1.3";
	public static final String StudyRootQueryRetrieveInformationModelFIND = "1.2.840.10008.5.1.4.1.2.2.1";
	public static final String StudyRootQueryRetrieveInformationModelMOVE = "1.2.840.10008.5.1.4.1.2.2.2";
	public static final String StudyRootQueryRetrieveInformationModelGET = "1.2.840.10008.5.1.4.1.2.2.3";
	public static final String PatientStudyOnlyQueryRetrieveInformationModelFINDRetired = "1.2.840.10008.5.1.4.1.2.3.1";
	public static final String PatientStudyOnlyQueryRetrieveInformationModelMOVERetired = "1.2.840.10008.5.1.4.1.2.3.2";
	public static final String PatientStudyOnlyQueryRetrieveInformationModelGETRetired = "1.2.840.10008.5.1.4.1.2.3.3";
	public static final String CompositeInstanceRootRetrieveMOVE = "1.2.840.10008.5.1.4.1.2.4.2";
	public static final String CompositeInstanceRootRetrieveGET = "1.2.840.10008.5.1.4.1.2.4.3";
	public static final String CompositeInstanceRetrieveWithoutBulkDataGET = "1.2.840.10008.5.1.4.1.2.5.3";
	public static final String DefinedProcedureProtocolInformationModelFIND = "1.2.840.10008.5.1.4.20.1";
	public static final String DefinedProcedureProtocolInformationModelMOVE = "1.2.840.10008.5.1.4.20.2";
	public static final String DefinedProcedureProtocolInformationModelGET = "1.2.840.10008.5.1.4.20.3";
	public static final String ModalityWorklistInformationModelFIND = "1.2.840.10008.5.1.4.31";
	public static final String GeneralPurposeWorklistManagementMetaSOPClassRetired = "1.2.840.10008.5.1.4.32";
	public static final String GeneralPurposeWorklistInformationModelFINDRetired = "1.2.840.10008.5.1.4.32.1";
	public static final String GeneralPurposeScheduledProcedureStepSOPClassRetired = "1.2.840.10008.5.1.4.32.2";
	public static final String GeneralPurposePerformedProcedureStepSOPClassRetired = "1.2.840.10008.5.1.4.32.3";
	public static final String InstanceAvailabilityNotificationSOPClass = "1.2.840.10008.5.1.4.33";
	public static final String RTBeamsDeliveryInstructionStorageTrialRetired = "1.2.840.10008.5.1.4.34.1";
	public static final String RTConventionalMachineVerificationTrialRetired = "1.2.840.10008.5.1.4.34.2";
	public static final String RTIonMachineVerificationTrialRetired = "1.2.840.10008.5.1.4.34.3";
	public static final String UnifiedWorklistAndProcedureStepServiceClassTrialRetired = "1.2.840.10008.5.1.4.34.4";
	public static final String UnifiedProcedureStepPushSOPClassTrialRetired = "1.2.840.10008.5.1.4.34.4.1";
	public static final String UnifiedProcedureStepWatchSOPClassTrialRetired = "1.2.840.10008.5.1.4.34.4.2";
	public static final String UnifiedProcedureStepPullSOPClassTrialRetired = "1.2.840.10008.5.1.4.34.4.3";
	public static final String UnifiedProcedureStepEventSOPClassTrialRetired = "1.2.840.10008.5.1.4.34.4.4";
	public static final String UPSGlobalSubscriptionSOPInstance = "1.2.840.10008.5.1.4.34.5";
	public static final String UPSFilteredGlobalSubscriptionSOPInstance = "1.2.840.10008.5.1.4.34.5.1";
	public static final String UnifiedWorklistAndProcedureStepServiceClass = "1.2.840.10008.5.1.4.34.6";
	public static final String UnifiedProcedureStepPushSOPClass = "1.2.840.10008.5.1.4.34.6.1";
	public static final String UnifiedProcedureStepWatchSOPClass = "1.2.840.10008.5.1.4.34.6.2";
	public static final String UnifiedProcedureStepPullSOPClass = "1.2.840.10008.5.1.4.34.6.3";
	public static final String UnifiedProcedureStepEventSOPClass = "1.2.840.10008.5.1.4.34.6.4";
	public static final String RTBeamsDeliveryInstructionStorage = "1.2.840.10008.5.1.4.34.7";
	public static final String RTConventionalMachineVerification = "1.2.840.10008.5.1.4.34.8";
	public static final String RTIonMachineVerification = "1.2.840.10008.5.1.4.34.9";
	public static final String RTBrachyApplicationSetupDeliveryInstructionStorage = "1.2.840.10008.5.1.4.34.10";
	public static final String GeneralRelevantPatientInformationQuery = "1.2.840.10008.5.1.4.37.1";
	public static final String BreastImagingRelevantPatientInformationQuery = "1.2.840.10008.5.1.4.37.2";
	public static final String CardiacRelevantPatientInformationQuery = "1.2.840.10008.5.1.4.37.3";
	public static final String HangingProtocolStorage = "1.2.840.10008.5.1.4.38.1";
	public static final String HangingProtocolInformationModelFIND = "1.2.840.10008.5.1.4.38.2";
	public static final String HangingProtocolInformationModelMOVE = "1.2.840.10008.5.1.4.38.3";
	public static final String HangingProtocolInformationModelGET = "1.2.840.10008.5.1.4.38.4";
	public static final String ColorPaletteStorage = "1.2.840.10008.5.1.4.39.1";
	public static final String ColorPaletteQueryRetrieveInformationModelFIND = "1.2.840.10008.5.1.4.39.2";
	public static final String ColorPaletteQueryRetrieveInformationModelMOVE = "1.2.840.10008.5.1.4.39.3";
	public static final String ColorPaletteQueryRetrieveInformationModelGET = "1.2.840.10008.5.1.4.39.4";
	public static final String ProductCharacteristicsQuerySOPClass = "1.2.840.10008.5.1.4.41";
	public static final String SubstanceApprovalQuerySOPClass = "1.2.840.10008.5.1.4.42";
	public static final String GenericImplantTemplateStorage = "1.2.840.10008.5.1.4.43.1";
	public static final String GenericImplantTemplateInformationModelFIND = "1.2.840.10008.5.1.4.43.2";
	public static final String GenericImplantTemplateInformationModelMOVE = "1.2.840.10008.5.1.4.43.3";
	public static final String GenericImplantTemplateInformationModelGET = "1.2.840.10008.5.1.4.43.4";
	public static final String ImplantAssemblyTemplateStorage = "1.2.840.10008.5.1.4.44.1";
	public static final String ImplantAssemblyTemplateInformationModelFIND = "1.2.840.10008.5.1.4.44.2";
	public static final String ImplantAssemblyTemplateInformationModelMOVE = "1.2.840.10008.5.1.4.44.3";
	public static final String ImplantAssemblyTemplateInformationModelGET = "1.2.840.10008.5.1.4.44.4";
	public static final String ImplantTemplateGroupStorage = "1.2.840.10008.5.1.4.45.1";
	public static final String ImplantTemplateGroupInformationModelFIND = "1.2.840.10008.5.1.4.45.2";
	public static final String ImplantTemplateGroupInformationModelMOVE = "1.2.840.10008.5.1.4.45.3";
	public static final String ImplantTemplateGroupInformationModelGET = "1.2.840.10008.5.1.4.45.4";
	public static final String NativeDICOMModel = "1.2.840.10008.7.1.1";
	public static final String AbstractMultiDimensionalImageModel = "1.2.840.10008.7.1.2";
	public static final String DICOMContentMappingResource = "1.2.840.10008.8.1.1";
	public static final String dicomDeviceName = "1.2.840.10008.15.0.3.1";
	public static final String dicomDescription = "1.2.840.10008.15.0.3.2";
	public static final String dicomManufacturer = "1.2.840.10008.15.0.3.3";
	public static final String dicomManufacturerModelName = "1.2.840.10008.15.0.3.4";
	public static final String dicomSoftwareVersion = "1.2.840.10008.15.0.3.5";
	public static final String dicomVendorData = "1.2.840.10008.15.0.3.6";
	public static final String dicomAETitle = "1.2.840.10008.15.0.3.7";
	public static final String dicomNetworkConnectionReference = "1.2.840.10008.15.0.3.8";
	public static final String dicomApplicationCluster = "1.2.840.10008.15.0.3.9";
	public static final String dicomAssociationInitiator = "1.2.840.10008.15.0.3.10";
	public static final String dicomAssociationAcceptor = "1.2.840.10008.15.0.3.11";
	public static final String dicomHostname = "1.2.840.10008.15.0.3.12";
	public static final String dicomPort = "1.2.840.10008.15.0.3.13";
	public static final String dicomSOPClass = "1.2.840.10008.15.0.3.14";
	public static final String dicomTransferRole = "1.2.840.10008.15.0.3.15";
	public static final String dicomTransferSyntax = "1.2.840.10008.15.0.3.16";
	public static final String dicomPrimaryDeviceType = "1.2.840.10008.15.0.3.17";
	public static final String dicomRelatedDeviceReference = "1.2.840.10008.15.0.3.18";
	public static final String dicomPreferredCalledAETitle = "1.2.840.10008.15.0.3.19";
	public static final String dicomTLSCyphersuite = "1.2.840.10008.15.0.3.20";
	public static final String dicomAuthorizedNodeCertificateReference = "1.2.840.10008.15.0.3.21";
	public static final String dicomThisNodeCertificateReference = "1.2.840.10008.15.0.3.22";
	public static final String dicomInstalled = "1.2.840.10008.15.0.3.23";
	public static final String dicomStationName = "1.2.840.10008.15.0.3.24";
	public static final String dicomDeviceSerialNumber = "1.2.840.10008.15.0.3.25";
	public static final String dicomInstitutionName = "1.2.840.10008.15.0.3.26";
	public static final String dicomInstitutionAddress = "1.2.840.10008.15.0.3.27";
	public static final String dicomInstitutionDepartmentName = "1.2.840.10008.15.0.3.28";
	public static final String dicomIssuerOfPatientID = "1.2.840.10008.15.0.3.29";
	public static final String dicomPreferredCallingAETitle = "1.2.840.10008.15.0.3.30";
	public static final String dicomSupportedCharacterSet = "1.2.840.10008.15.0.3.31";
	public static final String dicomConfigurationRoot = "1.2.840.10008.15.0.4.1";
	public static final String dicomDevicesRoot = "1.2.840.10008.15.0.4.2";
	public static final String dicomUniqueAETitlesRegistryRoot = "1.2.840.10008.15.0.4.3";
	public static final String dicomDevice = "1.2.840.10008.15.0.4.4";
	public static final String dicomNetworkAE = "1.2.840.10008.15.0.4.5";
	public static final String dicomNetworkConnection = "1.2.840.10008.15.0.4.6";
	public static final String dicomUniqueAETitle = "1.2.840.10008.15.0.4.7";
	public static final String dicomTransferCapability = "1.2.840.10008.15.0.4.8";
	public static final String UniversalCoordinatedTime = "1.2.840.10008.15.1.1";
	public static final String PrivateAgfaBasicAttributePresentationState = "1.2.124.113532.3500.7";
	public static final String PrivateAgfaArrivalTransaction = "1.2.124.113532.3500.8.1";
	public static final String PrivateAgfaDictationTransaction = "1.2.124.113532.3500.8.2";
	public static final String PrivateAgfaReportTranscriptionTransaction = "1.2.124.113532.3500.8.3";
	public static final String PrivateAgfaReportApprovalTransaction = "1.2.124.113532.3500.8.4";
	public static final String PrivateTomTecAnnotationStorage = "1.2.276.0.48.5.1.4.1.1.7";
	public static final String PrivateToshibaUSImageStorage = "1.2.392.200036.9116.7.8.1.1.1";
	public static final String PrivateFujiCRImageStorage = "1.2.392.200036.9125.1.1.2";
	public static final String PrivateGECollageStorage = "1.2.528.1.1001.5.1.1.1";
	public static final String PrivateERADPracticeBuilderReportTextStorage = "1.2.826.0.1.3680043.293.1.0.1";
	public static final String PrivateERADPracticeBuilderReportDictationStorage = "1.2.826.0.1.3680043.293.1.0.2";
	public static final String PrivatePhilipsHPLive3D01Storage = "1.2.840.113543.6.6.1.3.10001";
	public static final String PrivatePhilipsHPLive3D02Storage = "1.2.840.113543.6.6.1.3.10002";
	public static final String PrivateGE3DModelStorage = "1.2.840.113619.4.26";
	public static final String PrivateGEDicomCTImageInfoObject = "1.2.840.113619.4.3";
	public static final String PrivateGEDicomDisplayImageInfoObject = "1.2.840.113619.4.4";
	public static final String PrivateGEDicomMRImageInfoObject = "1.2.840.113619.4.2";
	public static final String PrivateGEeNTEGRAProtocolOrNMGenieStorage = "1.2.840.113619.4.27";
	public static final String PrivateGEPETRawDataStorage = "1.2.840.113619.4.30";
	public static final String PrivateGERTPlanStorage = "1.2.840.113619.4.5.249";
	public static final String PrivatePixelMedLegacyConvertedEnhancedCTImageStorage = "1.3.6.1.4.1.5962.301.1";
	public static final String PrivatePixelMedLegacyConvertedEnhancedMRImageStorage = "1.3.6.1.4.1.5962.301.2";
	public static final String PrivatePixelMedLegacyConvertedEnhancedPETImageStorage = "1.3.6.1.4.1.5962.301.3";
	public static final String PrivatePixelMedFloatingPointImageStorage = "1.3.6.1.4.1.5962.301.9";
	public static final String PrivateSiemensCSANonImageStorage = "1.3.12.2.1107.5.9.1";
	public static final String PrivateSiemensCTMRVolumeStorage = "1.3.12.2.1107.5.99.3.10";
	public static final String PrivateSiemensAXFrameSetsStorage = "1.3.12.2.1107.5.99.3.11";
	public static final String PrivatePhilipsSpecialisedXAStorage = "1.3.46.670589.2.3.1.1";
	public static final String PrivatePhilipsCXImageStorage = "1.3.46.670589.2.4.1.1";
	public static final String PrivatePhilips3DPresentationStateStorage = "1.3.46.670589.2.5.1.1";
	public static final String PrivatePhilipsVRMLStorage = "1.3.46.670589.2.8.1.1";
	public static final String PrivatePhilipsVolumeSetStorage = "1.3.46.670589.2.11.1.1";
	public static final String PrivatePhilipsVolumeStorageRetired = "1.3.46.670589.5.0.1";
	public static final String PrivatePhilipsVolumeStorage = "1.3.46.670589.5.0.1.1";
	public static final String PrivatePhilips3DObjectStorageRetired = "1.3.46.670589.5.0.2";
	public static final String PrivatePhilips3DObjectStorage = "1.3.46.670589.5.0.2.1";
	public static final String PrivatePhilipsSurfaceStorageRetired = "1.3.46.670589.5.0.3";
	public static final String PrivatePhilipsSurfaceStorage = "1.3.46.670589.5.0.3.1";
	public static final String PrivatePhilipsCompositeObjectStorage = "1.3.46.670589.5.0.4";
	public static final String PrivatePhilipsMRCardioProfileStorage = "1.3.46.670589.5.0.7";
	public static final String PrivatePhilipsMRCardioStorageRetired = "1.3.46.670589.5.0.8";
	public static final String PrivatePhilipsMRCardioStorage = "1.3.46.670589.5.0.8.1";
	public static final String PrivatePhilipsCTSyntheticImageStorage = "1.3.46.670589.5.0.9";
	public static final String PrivatePhilipsMRSyntheticImageStorage = "1.3.46.670589.5.0.10";
	public static final String PrivatePhilipsMRCardioAnalysisStorageRetired = "1.3.46.670589.5.0.11";
	public static final String PrivatePhilipsMRCardioAnalysisStorage = "1.3.46.670589.5.0.11.1";
	public static final String PrivatePhilipsCXSyntheticImageStorage = "1.3.46.670589.5.0.12";
	public static final String PrivatePhilipsPerfusionStorage = "1.3.46.670589.5.0.13";
	public static final String PrivatePhilipsPerfusionImageStorage = "1.3.46.670589.5.0.14";
	public static final String PrivatePhilipsXRayMFStorage = "1.3.46.670589.7.8.1618510091";
	public static final String PrivatePhilipsLiveRunStorage = "1.3.46.670589.7.8.1618510092";
	public static final String PrivatePhilipsRunStorage = "1.3.46.670589.7.8.16185100129";
	public static final String PrivatePhilipsReconstructionStorage = "1.3.46.670589.7.8.16185100130";
	public static final String PrivatePhilipsMRSpectrumStorage = "1.3.46.670589.11.0.0.12.1";
	public static final String PrivatePhilipsMRSeriesDataStorage = "1.3.46.670589.11.0.0.12.2";
	public static final String PrivatePhilipsMRColorImageStorage = "1.3.46.670589.11.0.0.12.3";
	public static final String PrivatePhilipsMRExamcardStorage = "1.3.46.670589.11.0.0.12.4";
	public static final String PrivatePMODMultiframeImageStorage = "2.16.840.1.114033.5.1.4.1.1.130";
}

/*
 * Location:
 * /home/vagrant/workspace/dicomdir/DicomdirDCM/lib/dcm4che-core-3.3.8.jar
 * Qualified Name: dcm.org.dcm4che3.data.UID Java Class Version: 6 (50.0) JD-Core
 * Version: 0.7.1
 */